/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.config;

import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import mezz.jei.common.config.IModIdFormatConfig;
import mezz.jei.common.config.file.ConfigCategoryBuilder;
import mezz.jei.common.config.file.ConfigSchemaBuilder;
import mezz.jei.common.config.file.ConfigValue;
import mezz.jei.common.config.file.serializers.ChatFormattingSerializer;
import mezz.jei.common.platform.IPlatformItemStackHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.core.util.function.CachedSupplierTransformer;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class ModIdFormatConfig
implements IModIdFormatConfig {
    protected static final List<class_124> defaultModNameFormat = List.of(class_124.field_1078, class_124.field_1056);
    public static final String MOD_NAME_FORMAT_CODE = "%MODNAME%";
    private final Supplier<String> modNameFormat;
    @Nullable
    private String cachedOverride;

    public ModIdFormatConfig(ConfigSchemaBuilder builder) {
        ConfigCategoryBuilder modName = builder.addCategory("modname");
        Supplier<List<class_124>> configValue = modName.addValue(new ConfigValue<List<class_124>>("ModNameFormat", defaultModNameFormat, ChatFormattingSerializer.INSTANCE, "Formatting for mod name tooltip"));
        this.modNameFormat = new CachedSupplierTransformer<List, String>(configValue, ModIdFormatConfig::toFormatString);
    }

    private static String toFormatString(List<class_124> values) {
        return values.stream().map(class_124::toString).collect(Collectors.joining());
    }

    private String getOverride() {
        if (this.cachedOverride == null) {
            this.cachedOverride = this.detectModNameTooltipFormatting();
        }
        return this.cachedOverride;
    }

    @Override
    public final String getModNameFormat() {
        String override = this.getOverride();
        if (!override.isEmpty()) {
            return override;
        }
        return this.modNameFormat.get();
    }

    @Override
    public final boolean isModNameFormatOverrideActive() {
        return !this.getOverride().isEmpty();
    }

    private String detectModNameTooltipFormatting() {
        IPlatformItemStackHelper itemStackHelper = Services.PLATFORM.getItemStackHelper();
        List<class_2561> tooltip = itemStackHelper.getTestTooltip(new class_1799((class_1935)class_1802.field_8279));
        if (tooltip.size() <= 1) {
            return "";
        }
        for (int lineNum = 1; lineNum < tooltip.size(); ++lineNum) {
            String withoutFormatting;
            class_2561 line = tooltip.get(lineNum);
            String lineString = line.getString();
            if (!lineString.contains("Minecraft") || (withoutFormatting = class_124.method_539((String)lineString)) == null || !withoutFormatting.contains("Minecraft")) continue;
            return StringUtils.replaceOnce((String)lineString, (String)"Minecraft", (String)MOD_NAME_FORMAT_CODE);
        }
        return "";
    }
}

